require("dotenv").config();
const { ethers } = require("ethers");

// Charger la configuration
const provider = new ethers.JsonRpcProvider(`https://goerli.infura.io/v3/${process.env.INFURA_API_KEY}`);
const wallet = new ethers.Wallet(process.env.PRIVATE_KEY, provider);

// Adresse du contrat déployé (à récupérer lors du déploiement)
const contractAddress = "0xTON_ADRESSE_CONTRAT";
const contractABI = require("./artifacts/contracts/CryptoClickerToken.sol/CryptoClickerToken.json").abi;

const contract = new ethers.Contract(contractAddress, contractABI, wallet);

// Exemple : Lire le totalSupply du token
async function getTotalSupply() {
  const supply = await contract.totalSupply();
  console.log(`Total Supply: ${ethers.formatUnits(supply, 18)} CLK`);
}

// Exemple : Envoyer des tokens
async function sendTokens(to, amount) {
  const tx = await contract.transfer(to, ethers.parseUnits(amount.toString(), 18));
  await tx.wait();
  console.log(`Envoyé ${amount} CLK à ${to}`);
}

getTotalSupply(); // Teste la lecture du totalSupply
