const contractAddress = "0x05F05f9d80E7609c65E353d2F13770485811e948";
const contractABI = [
    {
        "inputs": [{"internalType": "uint256", "name": "_amount", "type": "uint256"}],
        "name": "withdrawTokens",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [],
        "name": "buyAutoClicker",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [],
        "name": "buyMultiplier",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        "inputs": [{"internalType": "uint256", "name": "_amount", "type": "uint256"}],
        "name": "getTokenValueInCAD",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function"
    },
    {
        "inputs": [],
        "name": "balanceOf",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function"
    }
];

let provider, signer, contract, userAddress, tokenBalance = 0;
let autoClickers = 0;
let multipliers = 0;
let tokenGainPerClick = 1; // Début avec 1 token par clic

// 📌 Connexion à MetaMask
async function connectMetamask() {
    if (!window.ethereum) return alert("❌ Installez MetaMask !");
    
    provider = new ethers.BrowserProvider(window.ethereum);
    signer = await provider.getSigner();
    userAddress = await signer.getAddress();
    contract = new ethers.Contract(contractAddress, contractABI, signer);

    document.getElementById("walletAddress").innerText = `✅ Connecté : ${userAddress.substring(0, 6)}...${userAddress.slice(-4)}`;
    document.getElementById("gameSection").style.display = "block";
    updateGameData();
}

// 📌 Gagner des tokens en cliquant
document.getElementById("clicker").addEventListener("click", async () => {
    tokenBalance += tokenGainPerClick;
    document.getElementById("tokenCount").innerText = tokenBalance.toString();
});

// 📌 Achat d'un Auto-Clicker
async function buyAutoClicker() {
    if (!contract) return alert("❌ Veuillez connecter MetaMask.");
    if (tokenBalance < 1000) return alert("❌ Pas assez de tokens !");
    
    try {
        const tx = await contract.buyAutoClicker();
        await tx.wait();
        autoClickers += 1;
        tokenBalance -= 1000;
        document.getElementById("autoClickerCount").innerText = autoClickers;
        updateGameData();
        alert("✅ Auto-Clicker acheté !");
    } catch (error) {
        console.error("Erreur achat Auto-Clicker :", error);
    }
}

// 📌 Achat d'un Multiplicateur
async function buyMultiplier() {
    if (!contract) return alert("❌ Veuillez connecter MetaMask.");
    if (tokenBalance < 2000) return alert("❌ Pas assez de tokens !");
    
    try {
        const tx = await contract.buyMultiplier();
        await tx.wait();
        multipliers += 1;
        tokenBalance -= 2000;
        tokenGainPerClick *= 2; // 🔥 Double le gain par clic
        document.getElementById("multiplierCount").innerText = multipliers;
        updateGameData();
        alert("✅ Multiplicateur acheté !");
    } catch (error) {
        console.error("Erreur achat Multiplicateur :", error);
    }
}

// 📌 Retrait des Tokens
async function withdrawTokens() {
    if (!contract) return alert("❌ Veuillez connecter MetaMask.");

    try {
        const balance = await contract.balanceOf(userAddress);
        const tokenValueInCAD = await contract.getTokenValueInCAD(balance);

        if (tokenValueInCAD < 50 * 10**18) {
            return alert(`❌ Vous devez accumuler au moins 50$ CAD. Actuellement : ${(tokenValueInCAD / 10**18).toFixed(2)} CAD.`);
        }

        const tx = await contract.withdrawTokens(balance);
        await tx.wait();
        alert("✅ Retrait effectué !");
        updateGameData();
    } catch (error) {
        console.error("Erreur retrait :", error);
    }
}

// 📌 Met à jour les valeurs en CAD et les améliorations
async function updateGameData() {
    if (!contract) return;

    try {
        const balance = await contract.balanceOf(userAddress);
        const tokenValueInCAD = await contract.getTokenValueInCAD(balance);
        
        document.getElementById("tokenCount").innerText = balance.toString();
        document.getElementById("minWithdrawTokens").innerText = (50 * 10**18) / tokenValueInCAD;
        document.getElementById("minWithdrawETH").innerText = (50 * 10**18 / tokenValueInCAD / 10**18).toFixed(6);
        document.getElementById("clicksRemaining").innerText = Math.ceil((50 * 10**18 - tokenValueInCAD) / tokenGainPerClick);
    } catch (error) {
        console.error("Erreur mise à jour :", error);
    }
}

// 📌 Lier les boutons aux événements
document.getElementById("connectMetamask").addEventListener("click", connectMetamask);
document.getElementById("buyAutoClicker").addEventListener("click", buyAutoClicker);
document.getElementById("buyMultiplier").addEventListener("click", buyMultiplier);
document.getElementById("withdraw").addEventListener("click", withdrawTokens);

// 📌 Auto-Clicker : Ajoute des tokens toutes les secondes
setInterval(() => {
    if (autoClickers > 0) {
        tokenBalance += autoClickers * tokenGainPerClick;
        document.getElementById("tokenCount").innerText = tokenBalance.toString();
    }
}, 1000);
