<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit();
}

// Vérifier si la requête est de type GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Récupérer les données
$user_id = $_SESSION['user_id'];
$contact_id = isset($_GET['contact_id']) ? $_GET['contact_id'] : null;

// Vérifier si l'ID du contact est valide
if (!$contact_id) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'ID de contact manquant']);
    exit();
}

// Nettoyer les données
$contact_id = filter_var($contact_id, FILTER_SANITIZE_NUMBER_INT);

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Récupérer l'état de frappe
$query = "SELECT is_typing, updated_at
          FROM typing_status
          WHERE user_id = :contact_id AND contact_id = :user_id
          LIMIT 1";

$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->bindParam(':contact_id', $contact_id);
$stmt->execute();

// Vérifier si l'état de frappe existe
if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Vérifier si l'état de frappe est récent (moins de 5 secondes)
    $updated_at = strtotime($row['updated_at']);
    $now = time();
    $is_typing = ($row['is_typing'] == 1 && ($now - $updated_at) < 5) ? true : false;
} else {
    $is_typing = false;
}

// Récupérer les informations du contact
$user = new User($db);
$user->id = $contact_id;
$user->readOne();

header('Content-Type: application/json');
echo json_encode([
    'success' => true,
    'is_typing' => $is_typing,
    'is_online' => $user->is_online,
    'last_login' => $user->last_login
]);
?>