-- Script SQL pour créer la base de données et les tables nécessaires

-- Créer la base de données si elle n'existe pas
CREATE DATABASE IF NOT EXISTS socialdev_messenger;

-- Utiliser la base de données
USE socialdev_messenger;

-- Table des utilisateurs
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    firstname VARCHAR(50) NOT NULL,
    lastname VARCHAR(50) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    profile_image VARCHAR(255) DEFAULT NULL,
    is_online TINYINT(1) DEFAULT 0,
    last_login DATETIME DEFAULT NULL,
    reset_token VARCHAR(255) DEFAULT NULL,
    reset_token_expires DATETIME DEFAULT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Table des messages
CREATE TABLE IF NOT EXISTS messages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    sender_id INT NOT NULL,
    receiver_id INT NOT NULL,
    message TEXT NOT NULL,
    is_read TINYINT(1) DEFAULT 0,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (sender_id) REFERENCES users(id),
    FOREIGN KEY (receiver_id) REFERENCES users(id)
);

-- Table des préférences utilisateur
CREATE TABLE IF NOT EXISTS user_preferences (
    user_id INT PRIMARY KEY,
    theme VARCHAR(20) DEFAULT 'light',
    notifications TINYINT(1) DEFAULT 1,
    sounds TINYINT(1) DEFAULT 1,
    show_status TINYINT(1) DEFAULT 1,
    read_receipts TINYINT(1) DEFAULT 1,
    typing_indicator TINYINT(1) DEFAULT 1,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

-- Table pour l'état de frappe
CREATE TABLE IF NOT EXISTS typing_status (
    user_id INT NOT NULL,
    contact_id INT NOT NULL,
    is_typing TINYINT(1) DEFAULT 0,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (user_id, contact_id),
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (contact_id) REFERENCES users(id)
);

-- Insérer quelques utilisateurs de test (mot de passe: password123)
INSERT INTO users (firstname, lastname, email, password, is_online, created_at) VALUES
('John', 'Doe', 'john@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 0, NOW()),
('Jane', 'Smith', 'jane@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 0, NOW()),
('Alice', 'Johnson', 'alice@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 0, NOW());

-- Insérer quelques messages de test
INSERT INTO messages (sender_id, receiver_id, message, is_read, created_at) VALUES
(1, 2, 'Bonjour Jane, comment vas-tu ?', 1, NOW() - INTERVAL 2 DAY),
(2, 1, 'Salut John, je vais bien merci ! Et toi ?', 1, NOW() - INTERVAL 2 DAY),
(1, 2, 'Très bien aussi, merci !', 1, NOW() - INTERVAL 1 DAY),
(3, 1, 'Salut John, as-tu terminé le projet ?', 0, NOW() - INTERVAL 12 HOUR),
(1, 3, 'Pas encore, mais j\'y travaille !', 1, NOW() - INTERVAL 10 HOUR);