<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Traitement du formulaire de paramètres généraux
if (isset($_POST['update_general'])) {
    // Mise à jour des paramètres généraux
    $theme = isset($_POST['theme']) ? $_POST['theme'] : 'light';
    $notifications = isset($_POST['notifications']) ? 1 : 0;
    $sounds = isset($_POST['sounds']) ? 1 : 0;
    
    // Mettre à jour les préférences de l'utilisateur
    if ($user->updatePreferences($theme, $notifications, $sounds)) {
        $success_message = "Vos paramètres généraux ont été mis à jour avec succès.";
        $active_tab = 'general';
    } else {
        $error_message = "Une erreur s'est produite lors de la mise à jour des paramètres.";
        $active_tab = 'general';
    }
}
?>

<div class="tab-pane <?php echo $active_tab === 'general' ? 'active' : ''; ?>" id="general">
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
        <h3>Paramètres généraux</h3>
        
        <div class="form-group">
            <label for="theme">Thème</label>
            <select name="theme" id="theme" class="form-control">
                <option value="light" <?php echo ($preferences['theme'] === 'light') ? 'selected' : ''; ?>>Clair</option>
                <option value="dark" <?php echo ($preferences['theme'] === 'dark') ? 'selected' : ''; ?>>Sombre</option>
                <option value="system" <?php echo ($preferences['theme'] === 'system') ? 'selected' : ''; ?>>Système</option>
            </select>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="notifications" <?php echo ($preferences['notifications'] == 1) ? 'checked' : ''; ?>>
                Activer les notifications
            </label>
            <p class="form-text">Recevez des notifications lorsque vous recevez de nouveaux messages</p>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="sounds" <?php echo ($preferences['sounds'] == 1) ? 'checked' : ''; ?>>
                Activer les sons
            </label>
            <p class="form-text">Jouez des sons lors de la réception de nouveaux messages</p>
        </div>
        
        <div class="form-group">
            <button type="submit" name="update_general" class="btn btn-primary">
                <i class="fas fa-save"></i> Enregistrer les modifications
            </button>
        </div>
    </form>
</div>