<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Traitement du formulaire de confidentialité
if (isset($_POST['update_privacy'])) {
    // Mise à jour des paramètres de confidentialité
    $show_status = isset($_POST['show_status']) ? 1 : 0;
    $read_receipts = isset($_POST['read_receipts']) ? 1 : 0;
    $typing_indicator = isset($_POST['typing_indicator']) ? 1 : 0;
    
    // Mettre à jour les paramètres de confidentialité
    if ($user->updatePrivacySettings($show_status, $read_receipts, $typing_indicator)) {
        $success_message = "Vos paramètres de confidentialité ont été mis à jour avec succès.";
        $active_tab = 'privacy';
    } else {
        $error_message = "Une erreur s'est produite lors de la mise à jour des paramètres.";
        $active_tab = 'privacy';
    }
}
?>

<div class="tab-pane <?php echo $active_tab === 'privacy' ? 'active' : ''; ?>" id="privacy">
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
        <h3>Paramètres de confidentialité</h3>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="show_status" <?php echo ($preferences['show_status'] == 1) ? 'checked' : ''; ?>>
                Afficher mon statut en ligne
            </label>
            <p class="form-text">Permettre aux autres utilisateurs de voir quand vous êtes en ligne</p>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="read_receipts" <?php echo ($preferences['read_receipts'] == 1) ? 'checked' : ''; ?>>
                Envoyer des confirmations de lecture
            </label>
            <p class="form-text">Permettre aux autres utilisateurs de savoir quand vous avez lu leurs messages</p>
        </div>
        
        <div class="form-group">
            <label class="checkbox-label">
                <input type="checkbox" name="typing_indicator" <?php echo ($preferences['typing_indicator'] == 1) ? 'checked' : ''; ?>>
                Afficher l'indicateur de frappe
            </label>
            <p class="form-text">Permettre aux autres utilisateurs de voir quand vous êtes en train d'écrire</p>
        </div>
        
        <div class="form-group">
            <button type="submit" name="update_privacy" class="btn btn-primary">
                <i class="fas fa-save"></i> Enregistrer les modifications
            </button>
        </div>
    </form>
</div>