<?php
// Vérifier si l'utilisateur est connecté directement
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

// Traitement du formulaire de sécurité
if (isset($_POST['update_security'])) {
    // Mise à jour des paramètres de sécurité
    $current_password = trim($_POST['current_password']);
    $new_password = trim($_POST['new_password']);
    $confirm_password = trim($_POST['confirm_password']);
    
    // Vérifier si les champs sont remplis
    if (empty($current_password)) {
        $error_message = "Veuillez entrer votre mot de passe actuel.";
        $active_tab = 'security';
    } elseif (empty($new_password)) {
        $error_message = "Veuillez entrer un nouveau mot de passe.";
        $active_tab = 'security';
    } elseif (strlen($new_password) < 6) {
        $error_message = "Le mot de passe doit contenir au moins 6 caractères.";
        $active_tab = 'security';
    } elseif ($new_password !== $confirm_password) {
        $error_message = "Les mots de passe ne correspondent pas.";
        $active_tab = 'security';
    } else {
        // Vérifier le mot de passe actuel
        if ($user->verifyPassword($current_password)) {
            // Mettre à jour le mot de passe
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            if ($user->updatePassword($hashed_password)) {
                $success_message = "Votre mot de passe a été mis à jour avec succès.";
                $active_tab = 'security';
            } else {
                $error_message = "Une erreur s'est produite lors de la mise à jour du mot de passe.";
                $active_tab = 'security';
            }
        } else {
            $error_message = "Le mot de passe actuel est incorrect.";
            $active_tab = 'security';
        }
    }
}
?>

<div class="tab-pane <?php echo $active_tab === 'security' ? 'active' : ''; ?>" id="security">
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="settings-form">
        <h3>Changer votre mot de passe</h3>
        
        <div class="form-group">
            <label for="current_password">Mot de passe actuel</label>
            <input type="password" id="current_password" name="current_password" class="form-control" placeholder="Entrez votre mot de passe actuel">
        </div>
        
        <div class="form-group">
            <label for="new_password">Nouveau mot de passe</label>
            <input type="password" id="new_password" name="new_password" class="form-control" placeholder="Entrez un nouveau mot de passe">
            <div class="password-strength">
                <div class="password-strength-bar">
                    <div class="password-strength-indicator"></div>
                </div>
                <div class="password-strength-text">Force du mot de passe: <span id="strength-text">Non défini</span></div>
            </div>
        </div>
        
        <div class="form-group">
            <label for="confirm_password">Confirmer le nouveau mot de passe</label>
            <input type="password" id="confirm_password" name="confirm_password" class="form-control" placeholder="Confirmez votre nouveau mot de passe">
        </div>
        
        <div class="form-group">
            <button type="submit" name="update_security" class="btn btn-primary">
                <i class="fas fa-key"></i> Changer le mot de passe
            </button>
        </div>
    </form>
    
    <div class="security-info">
        <h3>Sécurité du compte</h3>
        <p>Votre compte est protégé par un chiffrement de bout en bout. Tous vos messages sont chiffrés et ne peuvent être lus que par vous et vos destinataires.</p>
        
        <div class="security-tips">
            <h4>Conseils de sécurité</h4>
            <ul>
                <li>Utilisez un mot de passe fort et unique (au moins 8 caractères, avec des lettres majuscules, minuscules, des chiffres et des caractères spéciaux)</li>
                <li>Ne partagez jamais votre mot de passe avec quelqu'un d'autre</li>
                <li>Déconnectez-vous lorsque vous utilisez un appareil partagé</li>
                <li>Vérifiez régulièrement l'activité de votre compte</li>
                <li>Mettez à jour votre mot de passe régulièrement</li>
            </ul>
        </div>
    </div>
</div>