# Clone de Messenger

Ce projet est un clone de Messenger développé en PHP avec une base de données MySQL. Il permet aux utilisateurs de s'inscrire, se connecter et échanger des messages en temps réel.

## Fonctionnalités

- Inscription et connexion des utilisateurs
- Messagerie en temps réel
- Liste des contacts avec statut en ligne
- Profil utilisateur personnalisable
- Notifications de nouveaux messages
- Interface responsive
- Chiffrement des messages

## Configuration requise

- PHP 7.4 ou supérieur
- MySQL 5.7 ou supérieur
- Serveur web (Apache, Nginx, etc.)

## Installation

1. Clonez ce dépôt sur votre serveur web
2. Importez le fichier `db_setup.sql` dans votre base de données MySQL
3. Configurez les informations de connexion à la base de données dans `config/database.php`
4. Assurez-vous que les répertoires `uploads/profile` sont accessibles en écriture

## Configuration de la base de données

1. Créez une base de données MySQL nommée `socialdev_messenger`
2. Exécutez le script SQL `db_setup.sql` pour créer les tables et insérer les données de test
3. Modifiez le fichier `config/database.php` avec vos identifiants de connexion MySQL

## Comptes de test

- Email: john@example.com / Mot de passe: password123
- Email: jane@example.com / Mot de passe: password123
- Email: alice@example.com / Mot de passe: password123

## Structure du projet

```
messenger/
├── assets/
│   ├── css/
│   │   └── style.css
│   ├── js/
│   │   └── app.js
│   └── images/
│       └── default-avatar.png
├── config/
│   └── database.php
├── models/
│   ├── User.php
│   └── Message.php
├── uploads/
│   └── profile/
├── index.php
├── login.php
├── register.php
├── logout.php
├── profile.php
├── send_message.php
├── check_messages.php
├── forgot_password.php
└── db_setup.sql
```

## Sécurité

- Tous les messages sont chiffrés en AES-256-CBC
- Protection CSRF sur tous les formulaires
- Validation des entrées utilisateur
- Mots de passe hachés avec bcrypt