<?php
session_start();

// Vérifier si l'utilisateur est déjà connecté
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Initialiser les variables
$token = $password = $confirm_password = "";
$token_err = $password_err = $confirm_password_err = "";
$success_message = $error_message = "";

// Vérifier si le token est présent dans l'URL
if (empty(trim($_GET["token"]))) {
    $token_err = "Token invalide ou manquant.";
} else {
    $token = trim($_GET["token"]);
}

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Valider le token
    if (empty(trim($_POST["token"]))) {
        $token_err = "Token invalide ou manquant.";
    } else {
        $token = trim($_POST["token"]);
    }
    
    // Valider le mot de passe
    if (empty(trim($_POST["password"]))) {
        $password_err = "Veuillez entrer un mot de passe.";
    } elseif (strlen(trim($_POST["password"])) < 6) {
        $password_err = "Le mot de passe doit contenir au moins 6 caractères.";
    } else {
        $password = trim($_POST["password"]);
    }
    
    // Valider la confirmation du mot de passe
    if (empty(trim($_POST["confirm_password"]))) {
        $confirm_password_err = "Veuillez confirmer le mot de passe.";
    } else {
        $confirm_password = trim($_POST["confirm_password"]);
        if (empty($password_err) && ($password != $confirm_password)) {
            $confirm_password_err = "Les mots de passe ne correspondent pas.";
        }
    }
    
    // Vérifier les erreurs avant de continuer
    if (empty($token_err) && empty($password_err) && empty($confirm_password_err)) {
        // Instancier la base de données
        $database = new Database();
        $db = $database->getConnection();
        
        // Instancier l'objet User
        $user = new User($db);
        
        // Vérifier si le token est valide et non expiré
        if ($user->verifyResetToken($token)) {
            // Mettre à jour le mot de passe
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            if ($user->resetPassword($token, $hashed_password)) {
                $success_message = "Votre mot de passe a été réinitialisé avec succès. Vous pouvez maintenant vous <a href='login.php'>connecter</a>.";
            } else {
                $error_message = "Une erreur s'est produite lors de la réinitialisation du mot de passe.";
            }
        } else {
            $token_err = "Le token est invalide ou a expiré.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Réinitialisation du mot de passe - Aurore</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-form-container">
            <div class="auth-logo">
                <i class="fab fa-facebook-messenger"></i>
                <h1>Aurore</h1>
            </div>
            
            <h2>Réinitialisation du mot de passe</h2>
            
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php elseif (!empty($error_message)): ?>
                <div class="alert alert-danger"><?php echo $error_message; ?></div>
            <?php elseif (!empty($token_err)): ?>
                <div class="alert alert-danger"><?php echo $token_err; ?></div>
                <div class="auth-footer">
                    <p><a href="forgot_password.php">Demander un nouveau lien de réinitialisation</a></p>
                </div>
            <?php else: ?>
                <p class="auth-subtitle">Veuillez choisir un nouveau mot de passe.</p>
                
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="auth-form">
                    <input type="hidden" name="token" value="<?php echo $token; ?>">
                    
                    <div class="form-group <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
                        <label>Nouveau mot de passe</label>
                        <input type="password" name="password" class="form-control">
                        <span class="error-message"><?php echo $password_err; ?></span>
                    </div>
                    
                    <div class="form-group <?php echo (!empty($confirm_password_err)) ? 'has-error' : ''; ?>">
                        <label>Confirmer le mot de passe</label>
                        <input type="password" name="confirm_password" class="form-control">
                        <span class="error-message"><?php echo $confirm_password_err; ?></span>
                    </div>
                    
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-block">Réinitialiser le mot de passe</button>
                    </div>
                </form>
            <?php endif; ?>
            
            <div class="auth-footer">
                <p><a href="login.php">Retour à la connexion</a></p>
            </div>
        </div>
    </div>
</body>
</html>