<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";
include_once "models/Message.php";

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet User
$user = new User($db);
$user->id = $_SESSION['user_id'];

// Instancier l'objet Message
$message = new Message($db);

// Récupérer la liste des contacts
$contacts = $user->getContacts();

// Ajouter le nombre de messages non lus pour chaque contact
if (!empty($contacts)) {
    foreach ($contacts as &$contact) {
        $contact['unread_count'] = $message->getUnreadCount($_SESSION['user_id'], $contact['id']);
    }
}

// Renvoyer la liste des contacts
header('Content-Type: application/json');
echo json_encode(['success' => true, 'contacts' => $contacts]);
?>