<?php
session_start();

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Mettre à jour le statut en ligne si l'utilisateur est connecté
if (isset($_SESSION['user_id'])) {
    // Instancier la base de données
    $database = new Database();
    $db = $database->getConnection();
    
    // Instancier l'objet User
    $user = new User($db);
    $user->id = $_SESSION['user_id'];
    
    // Mettre à jour le statut en ligne (0 = hors ligne)
    $user->updateOnlineStatus(0);
    
    // Mettre à jour la dernière connexion
    $user->updateLastLogin();
}

// Détruire toutes les variables de session
$_SESSION = array();

// Détruire la session
session_destroy();

// Rediriger vers la page de connexion
header("location: login.php");
exit;
?>