$(document).ready(function() {
    // Fonction pour faire défiler les messages vers le bas
    function scrollToBottom() {
        var chatMessages = document.getElementById('chat-messages');
        if (chatMessages) {
            chatMessages.scrollTop = chatMessages.scrollHeight;
        }
    }
    
    // Faire défiler les messages vers le bas au chargement de la page
    scrollToBottom();
    
    // Recherche de contacts
    $('#search-contact').on('input', function() {
        var searchText = $(this).val().toLowerCase();
        
        $('.contact-item').each(function() {
            var contactName = $(this).find('h4').text().toLowerCase();
            
            if (contactName.indexOf(searchText) > -1) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
    
    // Envoyer un message via AJAX
    $('#message-form').submit(function(e) {
        e.preventDefault();
        
        var form = $(this);
        var messageInput = form.find('input[name="message"]');
        var message = messageInput.val().trim();
        
        if (message !== '') {
            $.ajax({
                type: 'POST',
                url: form.attr('action'),
                data: form.serialize(),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Ajouter le message à la conversation
                        var currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                        
                        var newMessage = `
                            <div class="message sent">
                                <div class="message-content">
                                    ${message}
                                    <span class="message-time">${currentTime}</span>
                                </div>
                            </div>
                        `;
                        
                        $('#chat-messages').append(newMessage);
                        
                        // Vider le champ de saisie
                        messageInput.val('');
                        
                        // Faire défiler vers le bas
                        scrollToBottom();
                    }
                }
            });
        }
    });
    
    // Vérifier les nouveaux messages toutes les 5 secondes
    function checkNewMessages() {
        var contactId = new URLSearchParams(window.location.search).get('contact_id');
        var lastMessageId = $('.message').last().data('message-id') || 0;
        
        if (contactId) {
            $.ajax({
                type: 'GET',
                url: 'check_messages.php',
                data: { 
                    contact_id: contactId,
                    last_id: lastMessageId
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.messages.length > 0) {
                        // Ajouter les nouveaux messages à la conversation
                        response.messages.forEach(function(msg) {
                            var messageClass = (msg.sender_id == contactId) ? 'received' : 'sent';
                            
                            var newMessage = `
                                <div class="message ${messageClass}" data-message-id="${msg.id}">
                                    <div class="message-content">
                                        ${msg.message}
                                        <span class="message-time">${msg.created_at}</span>
                                    </div>
                                </div>
                            `;
                            
                            $('#chat-messages').append(newMessage);
                        });
                        
                        // Faire défiler vers le bas
                        scrollToBottom();
                    }
                }
            });
        }
    }
    
    // Vérifier les nouveaux messages toutes les 5 secondes
    setInterval(checkNewMessages, 5000);
    
    // Fonctionnalités des boutons d'action
    
    // Bouton d'appel téléphonique
    $('.chat-actions button:nth-child(1)').click(function() {
        alert('Fonctionnalité d\'appel téléphonique en cours de développement');
    });
    
    // Bouton d'appel vidéo
    $('.chat-actions button:nth-child(2)').click(function() {
        alert('Fonctionnalité d\'appel vidéo en cours de développement');
    });
    
    // Bouton d'informations
    $('.chat-actions button:nth-child(3)').click(function() {
        var contactId = new URLSearchParams(window.location.search).get('contact_id');
        if (contactId) {
            window.location.href = 'contact_info.php?id=' + contactId;
        }
    });
    
    // Boutons d'actions pour l'envoi de message
    
    // Bouton d'ajout (plus)
    $('.input-actions button:nth-child(1)').click(function() {
        alert('Fonctionnalité d\'ajout de contenu en cours de développement');
    });
    
    // Bouton d'envoi d'image
    $('.input-actions button:nth-child(2)').click(function() {
        $('#file-upload').click();
    });
    
    // Bouton d'envoi de pièce jointe
    $('.input-actions button:nth-child(3)').click(function() {
        $('#attachment-upload').click();
    });
    
    // Gestion des fichiers uploadés
    $('#file-upload').change(function() {
        var file = this.files[0];
        if (file) {
            var formData = new FormData();
            formData.append('file', file);
            formData.append('receiver_id', $('input[name="receiver_id"]').val());
            formData.append('type', 'image');
            formData.append('csrf_token', $('input[name="csrf_token"]').val());
            
            $.ajax({
                url: 'upload_file.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        // Ajouter l'image à la conversation
                        var currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                        
                        var newMessage = `
                            <div class="message sent">
                                <div class="message-content">
                                    <img src="${response.file_url}" alt="Image envoyée" class="message-image">
                                    <span class="message-time">${currentTime}</span>
                                </div>
                            </div>
                        `;
                        
                        $('#chat-messages').append(newMessage);
                        scrollToBottom();
                    } else {
                        alert('Erreur lors de l\'envoi de l\'image');
                    }
                },
                error: function() {
                    alert('Erreur lors de l\'envoi de l\'image');
                }
            });
        }
    });
    
    // Gestion des pièces jointes
    $('#attachment-upload').change(function() {
        var file = this.files[0];
        if (file) {
            var formData = new FormData();
            formData.append('file', file);
            formData.append('receiver_id', $('input[name="receiver_id"]').val());
            formData.append('type', 'file');
            formData.append('csrf_token', $('input[name="csrf_token"]').val());
            
            $.ajax({
                url: 'upload_file.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        // Ajouter le fichier à la conversation
                        var currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                        
                        var newMessage = `
                            <div class="message sent">
                                <div class="message-content">
                                    <a href="${response.file_url}" target="_blank" class="message-file">
                                        <i class="fas fa-file"></i> ${file.name}
                                    </a>
                                    <span class="message-time">${currentTime}</span>
                                </div>
                            </div>
                        `;
                        
                        $('#chat-messages').append(newMessage);
                        scrollToBottom();
                    } else {
                        alert('Erreur lors de l\'envoi du fichier');
                    }
                },
                error: function() {
                    alert('Erreur lors de l\'envoi du fichier');
                }
            });
        }
    });
    
    // Supprimer un message (clic droit)
    $(document).on('contextmenu', '.message.sent', function(e) {
        e.preventDefault();
        
        var messageId = $(this).data('message-id');
        if (confirm('Voulez-vous supprimer ce message ?')) {
            $.ajax({
                url: 'delete_message.php',
                type: 'POST',
                data: { 
                    message_id: messageId,
                    csrf_token: $('input[name="csrf_token"]').val()
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Supprimer le message de l'interface
                        $(`[data-message-id="${messageId}"]`).fadeOut(300, function() {
                            $(this).remove();
                        });
                    } else {
                        alert('Erreur lors de la suppression du message');
                    }
                }
            });
        }
    });
    
    // Lien vers la page de paramètres
    $('.user-actions a[title="Profil"]').parent().prepend('<a href="settings.php" title="Paramètres"><i class="fas fa-cog"></i></a>');
    
    // Indicateur de frappe
    var typingTimer;
    var isTyping = false;
    
    $('.chat-input input[name="message"]').on('input', function() {
        var contactId = new URLSearchParams(window.location.search).get('contact_id');
        
        if (!isTyping) {
            isTyping = true;
            // Envoyer l'état de frappe au serveur
            $.ajax({
                url: 'typing_status.php',
                type: 'POST',
                data: {
                    contact_id: contactId,
                    is_typing: 1,
                    csrf_token: $('input[name="csrf_token"]').val()
                }
            });
        }
        
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function() {
            isTyping = false;
            // Envoyer l'état de frappe au serveur
            $.ajax({
                url: 'typing_status.php',
                type: 'POST',
                data: {
                    contact_id: contactId,
                    is_typing: 0,
                    csrf_token: $('input[name="csrf_token"]').val()
                }
            });
        }, 2000);
    });
    
    // Vérifier l'état de frappe du contact
    function checkTypingStatus() {
        var contactId = new URLSearchParams(window.location.search).get('contact_id');
        
        if (contactId) {
            $.ajax({
                url: 'check_typing.php',
                type: 'GET',
                data: {
                    contact_id: contactId
                },
                dataType: 'json',
                success: function(response) {
                    if (response.is_typing) {
                        // Afficher l'indicateur de frappe
                        if ($('.typing-indicator').length === 0) {
                            $('.chat-header .contact-info .status').html('<span class="typing-indicator">En train d\'écrire...</span>');
                        }
                    } else {
                        // Masquer l'indicateur de frappe
                        $('.typing-indicator').remove();
                        // Restaurer le statut
                        if (response.is_online) {
                            $('.chat-header .contact-info .status').text('En ligne');
                        } else {
                            $('.chat-header .contact-info .status').text('Dernière connexion: ' + response.last_login);
                        }
                    }
                }
            });
        }
    }
    
    // Vérifier l'état de frappe toutes les 2 secondes
    setInterval(checkTypingStatus, 2000);
});