<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";
include_once "models/Message.php";

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier les objets User et Message
$user = new User($db);
$message = new Message($db);

// Récupérer l'ID de l'utilisateur connecté
$user_id = $_SESSION['user_id'];

// Récupérer les informations de l'utilisateur
$user->id = $user_id;
$user->readOne();

// Récupérer la liste des contacts
$contacts = $user->getContacts();

// Récupérer l'ID du contact sélectionné (si disponible)
$contact_id = isset($_GET['contact_id']) ? $_GET['contact_id'] : null;

// Générer un jeton CSRF pour la sécurité
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aurore - Messagerie</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; script-src 'self' https://code.jquery.com; style-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data:; font-src 'self' https://cdnjs.cloudflare.com;">
</head>
<body>
    <div class="messenger-container">
        <!-- Sidebar avec la liste des contacts -->
        <div class="sidebar">
            <div class="user-profile">
                <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile">
                <div class="user-info">
                    <h3><?php echo $user->firstname . ' ' . $user->lastname; ?></h3>
                    <div class="status online">
                        <span class="status-dot"></span>
                        <span class="status-text">En ligne</span>
                    </div>
                </div>
                <div class="user-actions">
                    <a href="settings.php" title="Paramètres"><i class="fas fa-cog"></i></a>
                    <a href="profile.php" title="Profil"><i class="fas fa-user"></i></a>
                    <a href="logout.php" title="Déconnexion"><i class="fas fa-sign-out-alt"></i></a>
                </div>
            </div>
            
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" placeholder="Rechercher..." id="search-contact">
            </div>
            
            <div class="contacts-list">
                <?php foreach ($contacts as $contact): ?>
                    <?php 
                    $active_class = ($contact_id == $contact['id']) ? 'active' : '';
                    $unread_count = $message->getUnreadCount($user_id, $contact['id']);
                    ?>
                    <a href="index.php?contact_id=<?php echo $contact['id']; ?>" class="contact-item <?php echo $active_class; ?>">
                        <div class="contact-avatar">
                            <img src="<?php echo $contact['profile_image'] ? 'uploads/profile/' . $contact['profile_image'] : 'assets/images/default-avatar.png'; ?>" alt="<?php echo $contact['firstname']; ?>">
                            <?php if ($contact['is_online']): ?>
                                <span class="status-indicator online"></span>
                            <?php else: ?>
                                <span class="status-indicator offline"></span>
                            <?php endif; ?>
                        </div>
                        <div class="contact-info">
                            <h4><?php echo $contact['firstname'] . ' ' . $contact['lastname']; ?></h4>
                            <p class="last-message"><?php echo $contact['last_message']; ?></p>
                        </div>
                        <div class="contact-meta">
                            <span class="time"><?php echo $contact['last_message_time']; ?></span>
                            <?php if ($unread_count > 0): ?>
                                <span class="unread-count"><?php echo $unread_count; ?></span>
                            <?php endif; ?>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Zone principale de chat -->
        <div class="chat-area">
            <?php if ($contact_id): ?>
                <?php 
                // Récupérer les informations du contact
                $contact_user = new User($db);
                $contact_user->id = $contact_id;
                $contact_user->readOne();
                
                // Récupérer les messages
                $messages = $message->getConversation($user_id, $contact_id);
                
                // Marquer les messages comme lus
                $message->markAsRead($contact_id, $user_id);
                ?>
                <div class="chat-header">
                    <div class="contact-info">
                        <img src="<?php echo $contact_user->profile_image ? 'uploads/profile/' . $contact_user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="<?php echo $contact_user->firstname; ?>">
                        <div>
                            <h3><?php echo $contact_user->firstname . ' ' . $contact_user->lastname; ?></h3>
                            <?php if ($contact_user->is_online): ?>
                                <span class="status">En ligne</span>
                            <?php else: ?>
                                <span class="status">Dernière connexion: <?php echo $contact_user->last_login; ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="chat-actions">
                        <button title="Appel téléphonique"><i class="fas fa-phone"></i></button>
                        <button title="Appel vidéo"><i class="fas fa-video"></i></button>
                        <button title="Informations"><i class="fas fa-info-circle"></i></button>
                    </div>
                </div>
                
                <div class="chat-messages" id="chat-messages">
                    <?php foreach ($messages as $msg): ?>
                        <div class="message <?php echo ($msg['sender_id'] == $user_id) ? 'sent' : 'received'; ?>" data-message-id="<?php echo $msg['id']; ?>">
                            <div class="message-content">
                                <?php echo $msg['message']; ?>
                                <span class="message-time"><?php echo $msg['created_at']; ?></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <div class="chat-input">
                    <div class="input-actions">
                        <button title="Ajouter du contenu"><i class="fas fa-plus-circle"></i></button>
                        <button title="Envoyer une image"><i class="fas fa-image"></i></button>
                        <button title="Joindre un fichier"><i class="fas fa-paperclip"></i></button>
                    </div>
                    <form id="message-form" action="send_message.php" method="post">
                        <input type="hidden" name="receiver_id" value="<?php echo $contact_id; ?>">
                        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                        <input type="text" name="message" placeholder="Écrivez un message..." autocomplete="off">
                        <button type="submit" title="Envoyer"><i class="fas fa-paper-plane"></i></button>
                    </form>
                    <!-- Champs cachés pour l'upload de fichiers -->
                    <input type="file" id="file-upload" accept="image/*" style="display: none;">
                    <input type="file" id="attachment-upload" style="display: none;">
                </div>
            <?php else: ?>
                <div class="no-chat-selected">
                    <div class="welcome-message">
                        <i class="fas fa-comments"></i>
                        <h2>Bienvenue sur Aurore</h2>
                        <p>Sélectionnez un contact pour commencer à discuter</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="assets/js/app.js"></script>
</body>
</html>