<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit();
}

// Vérifier si la requête est de type POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit();
}

// Vérifier le jeton CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Jeton CSRF invalide']);
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";

// Récupérer les données
$user_id = $_SESSION['user_id'];
$contact_id = isset($_POST['contact_id']) ? $_POST['contact_id'] : null;
$is_typing = isset($_POST['is_typing']) ? (int)$_POST['is_typing'] : 0;

// Vérifier si l'ID du contact est valide
if (!$contact_id) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'ID de contact manquant']);
    exit();
}

// Nettoyer les données
$contact_id = filter_var($contact_id, FILTER_SANITIZE_NUMBER_INT);

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Mettre à jour l'état de frappe
$query = "INSERT INTO typing_status (user_id, contact_id, is_typing, updated_at)
          VALUES (:user_id, :contact_id, :is_typing, NOW())
          ON DUPLICATE KEY UPDATE
          is_typing = :is_typing,
          updated_at = NOW()";

$stmt = $db->prepare($query);
$stmt->bindParam(':user_id', $user_id);
$stmt->bindParam(':contact_id', $contact_id);
$stmt->bindParam(':is_typing', $is_typing);

if ($stmt->execute()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => true]);
} else {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour de l\'état de frappe']);
}
?>