<?php
session_start();

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Instancier la base de données
$database = new Database();
$db = $database->getConnection();

// Instancier l'objet User
$user = new User($db);
$user->id = $_SESSION['user_id'];
$user->readOne();

// Initialiser les variables
$firstname = $user->firstname;
$lastname = $user->lastname;
$email = $user->email;
$current_password = $new_password = $confirm_password = "";
$firstname_err = $lastname_err = $email_err = $current_password_err = $new_password_err = $confirm_password_err = "";
$success_message = "";

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Valider le prénom
    if (empty(trim($_POST["firstname"]))) {
        $firstname_err = "Veuillez entrer votre prénom.";
    } else {
        $firstname = trim($_POST["firstname"]);
    }
    
    // Valider le nom
    if (empty(trim($_POST["lastname"]))) {
        $lastname_err = "Veuillez entrer votre nom.";
    } else {
        $lastname = trim($_POST["lastname"]);
    }
    
    // Valider l'email
    if (empty(trim($_POST["email"]))) {
        $email_err = "Veuillez entrer votre email.";
    } else {
        $email = trim($_POST["email"]);
        
        // Vérifier si l'email existe déjà (sauf si c'est le même que l'utilisateur actuel)
        if ($email !== $user->email && $user->emailExists($email)) {
            $email_err = "Cet email est déjà utilisé.";
        }
    }
    
    // Vérifier si le mot de passe actuel est fourni
    if (!empty(trim($_POST["current_password"]))) {
        $current_password = trim($_POST["current_password"]);
        
        // Valider le nouveau mot de passe
        if (empty(trim($_POST["new_password"]))) {
            $new_password_err = "Veuillez entrer le nouveau mot de passe.";
        } elseif (strlen(trim($_POST["new_password"])) < 6) {
            $new_password_err = "Le mot de passe doit contenir au moins 6 caractères.";
        } else {
            $new_password = trim($_POST["new_password"]);
        }
        
        // Valider la confirmation du mot de passe
        if (empty(trim($_POST["confirm_password"]))) {
            $confirm_password_err = "Veuillez confirmer le mot de passe.";
        } else {
            $confirm_password = trim($_POST["confirm_password"]);
            if (empty($new_password_err) && ($new_password != $confirm_password)) {
                $confirm_password_err = "Les mots de passe ne correspondent pas.";
            }
        }
    }
    
    // Vérifier les erreurs avant de mettre à jour la base de données
    if (empty($firstname_err) && empty($lastname_err) && empty($email_err) && 
        empty($current_password_err) && empty($new_password_err) && empty($confirm_password_err)) {
        
        // Mettre à jour les informations de l'utilisateur
        $user->firstname = $firstname;
        $user->lastname = $lastname;
        $user->email = $email;
        
        // Mettre à jour le mot de passe si nécessaire
        if (!empty($current_password)) {
            // Vérifier le mot de passe actuel
            if ($user->verifyPassword($current_password)) {
                $user->password = password_hash($new_password, PASSWORD_DEFAULT);
            } else {
                $current_password_err = "Le mot de passe actuel est incorrect.";
                goto render_page; // Sauter à l'affichage de la page
            }
        }
        
        // Traiter l'image de profil si elle est téléchargée
        if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = "uploads/profile/";
            
            // Créer le répertoire s'il n'existe pas
            if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            
            // Générer un nom de fichier unique
            $file_extension = pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION);
            $file_name = uniqid() . '.' . $file_extension;
            $target_file = $upload_dir . $file_name;
            
            // Vérifier si le fichier est une image
            $check = getimagesize($_FILES['profile_image']['tmp_name']);
            if ($check !== false) {
                // Déplacer le fichier téléchargé
                if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $target_file)) {
                    // Supprimer l'ancienne image si elle existe
                    if ($user->profile_image && file_exists($upload_dir . $user->profile_image)) {
                        unlink($upload_dir . $user->profile_image);
                    }
                    
                    $user->profile_image = $file_name;
                }
            }
        }
        
        // Mettre à jour l'utilisateur
        if ($user->update()) {
            $success_message = "Votre profil a été mis à jour avec succès.";
            
            // Mettre à jour les informations de session
            $_SESSION['email'] = $email;
        } else {
            $success_message = "Une erreur s'est produite lors de la mise à jour du profil.";
        }
    }
}

// Label pour l'affichage de la page
render_page:
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil - Messenger Clone</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="messenger-container">
        <!-- Sidebar avec la liste des contacts -->
        <div class="sidebar">
            <div class="user-profile">
                <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile">
                <div class="user-info">
                    <h3><?php echo $user->firstname . ' ' . $user->lastname; ?></h3>
                    <div class="status online">
                        <span class="status-dot"></span>
                        <span class="status-text">En ligne</span>
                    </div>
                </div>
                <div class="user-actions">
                    <a href="index.php" title="Messages"><i class="fas fa-comment"></i></a>
                    <a href="logout.php" title="Déconnexion"><i class="fas fa-sign-out-alt"></i></a>
                </div>
            </div>
        </div>
        
        <!-- Zone principale de profil -->
        <div class="profile-area">
            <div class="profile-header">
                <h2>Modifier votre profil</h2>
                <?php if (!empty($success_message)): ?>
                    <div class="alert alert-success"><?php echo $success_message; ?></div>
                <?php endif; ?>
            </div>
            
            <div class="profile-content">
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" enctype="multipart/form-data" class="profile-form">
                    <div class="profile-image-upload">
                        <div class="current-image">
                            <img src="<?php echo $user->profile_image ? 'uploads/profile/' . $user->profile_image : 'assets/images/default-avatar.png'; ?>" alt="Profile" id="profile-preview">
                        </div>
                        <div class="upload-controls">
                            <label for="profile_image" class="btn btn-primary">Changer la photo</label>
                            <input type="file" name="profile_image" id="profile_image" accept="image/*" style="display: none;">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group <?php echo (!empty($firstname_err)) ? 'has-error' : ''; ?>">
                            <label>Prénom</label>
                            <input type="text" name="firstname" class="form-control" value="<?php echo $firstname; ?>">
                            <span class="error-message"><?php echo $firstname_err; ?></span>
                        </div>
                        
                        <div class="form-group <?php echo (!empty($lastname_err)) ? 'has-error' : ''; ?>">
                            <label>Nom</label>
                            <input type="text" name="lastname" class="form-control" value="<?php echo $lastname; ?>">
                            <span class="error-message"><?php echo $lastname_err; ?></span>
                        </div>
                    </div>
                    
                    <div class="form-group <?php echo (!empty($email_err)) ? 'has-error' : ''; ?>">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" value="<?php echo $email; ?>">
                        <span class="error-message"><?php echo $email_err; ?></span>
                    </div>
                    
                    <div class="password-section">
                        <h3>Changer le mot de passe</h3>
                        
                        <div class="form-group <?php echo (!empty($current_password_err)) ? 'has-error' : ''; ?>">
                            <label>Mot de passe actuel</label>
                            <input type="password" name="current_password" class="form-control">
                            <span class="error-message"><?php echo $current_password_err; ?></span>
                        </div>
                        
                        <div class="form-group <?php echo (!empty($new_password_err)) ? 'has-error' : ''; ?>">
                            <label>Nouveau mot de passe</label>
                            <input type="password" name="new_password" class="form-control">
                            <span class="error-message"><?php echo $new_password_err; ?></span>
                        </div>
                        
                        <div class="form-group <?php echo (!empty($confirm_password_err)) ? 'has-error' : ''; ?>">
                            <label>Confirmer le nouveau mot de passe</label>
                            <input type="password" name="confirm_password" class="form-control">
                            <span class="error-message"><?php echo $confirm_password_err; ?></span>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                        <a href="index.php" class="btn btn-secondary">Annuler</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Prévisualisation de l'image de profil
        $(document).ready(function() {
            $('#profile_image').change(function() {
                var file = this.files[0];
                if (file) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#profile-preview').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(file);
                }
            });
        });
    </script>
</body>
</html>