<?php
session_start();

if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

require_once "config/database.php";
require_once "models/User.php";

$email = "";
$email_err = "";
$success_message = "";
$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (empty(trim($_POST["email"]))) {
        $email_err = "Veuillez entrer votre email.";
    } else {
        $email = trim($_POST["email"]);
    }
    
    if (empty($email_err)) {
        $database = new Database();
        $db = $database->getConnection();
        
        $user = new User($db);
        
        if ($userInfo = $user->getUserByEmail($email)) {
            // Générer un mot de passe temporaire
            $temp_password = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 8);
            $hashed_password = password_hash($temp_password, PASSWORD_DEFAULT);
            
            // Mettre à jour le mot de passe dans la base de données
            if ($user->updatePasswordByEmail($email, $hashed_password)) {
                $success_message = "Votre mot de passe temporaire est: " . $temp_password;
            } else {
                $error_message = "Une erreur s'est produite. Veuillez réessayer plus tard.";
            }
        } else {
            // Pour des raisons de sécurité, ne pas indiquer si l'email existe ou non
            $success_message = "Si votre email est enregistré, vous recevrez votre mot de passe temporaire.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mot de passe oublié - Messenger Clone</title>
    <link rel="stylesheet" href="assets/css/login.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="aurora-container">
        <div class="aurora-light"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
    </div>
    
    <div class="auth-container">
        <div class="auth-form-container">
            <div class="auth-logo">
                <div class="logo-icon">
                    <i class="fab fa-facebook-messenger"></i>
                </div>
                <h1 data-text="Messenger">Messenger Clone</h1>
            </div>
            
            <h2>Mot de passe oublié</h2>
            <p class="auth-subtitle">Entrez votre email pour recevoir un mot de passe temporaire.</p>
            
            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php endif; ?>
            
            <?php if (!empty($error_message)): ?>
                <div class="alert alert-danger"><?php echo $error_message; ?></div>
            <?php endif; ?>
            
            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="auth-form">
                <div class="form-group <?php echo (!empty($email_err)) ? 'has-error' : ''; ?>">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo $email; ?>">
                    <span class="error-message"><?php echo $email_err; ?></span>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-block">Réinitialiser le mot de passe</button>
                </div>
            </form>
            
            <div class="auth-footer">
                <p><a href="login.php">Retour à la connexion</a></p>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const auroraContainer = document.querySelector('.aurora-container');
        
        function createRandomFlash() {
            const flash = document.createElement('div');
            flash.className = 'aurora-flash';
            flash.style.position = 'absolute';
            flash.style.width = '100%';
            flash.style.height = '100%';
            flash.style.top = '0';
            flash.style.left = '0';
            flash.style.background = 'radial-gradient(ellipse at center, rgba(255,255,255,0) 0%, rgba(255,255,255,0) 70%, rgba(180,140,255,0.2) 100%)';
            flash.style.opacity = '0';
            flash.style.transition = 'opacity 0.5s ease-in-out';
            flash.style.pointerEvents = 'none';
            
            auroraContainer.appendChild(flash);
            
            setTimeout(() => {
                flash.style.opacity = '0.3';
                setTimeout(() => {
                    flash.style.opacity = '0';
                    setTimeout(() => {
                        flash.remove();
                    }, 500);
                }, 200);
            }, 100);
        }
        
        function createRandomWave() {
            const wave = document.createElement('div');
            wave.className = 'aurora-wave';
            
            const positions = [
                { top: '-100%', left: '-50%' },
                { top: '-80%', left: '-10%' },
                { top: '-60%', right: '-30%' },
                { bottom: '-80%', left: '10%' },
                { bottom: '-70%', right: '-20%' }
            ];
            
            const randomPosition = positions[Math.floor(Math.random() * positions.length)];
            
            Object.keys(randomPosition).forEach(key => {
                wave.style[key] = randomPosition[key];
            });
            
            const colors = [
                'var(--aurora1)',
                'var(--aurora2)',
                'var(--aurora3)',
                'var(--aurora4)',
                'var(--aurora5)',
                'var(--aurora6)',
                'var(--aurora7)',
                'var(--aurora8)'
            ];
            
            wave.style.background = colors[Math.floor(Math.random() * colors.length)];
            wave.style.opacity = '0';
            wave.style.filter = 'blur(60px)';
            wave.style.borderRadius = '40%';
            wave.style.width = '200%';
            wave.style.height = '200%';
            wave.style.transition = 'opacity 3s ease-in-out, transform 30s ease-in-out';
            wave.style.transform = 'translate(0%, 0%) rotate(0deg)';
            
            auroraContainer.appendChild(wave);
            
            setTimeout(() => {
                wave.style.opacity = '0.3';
                wave.style.transform = `translate(${Math.random() * 20 - 10}%, ${Math.random() * 20 - 10}%) rotate(${Math.random() * 20 - 10}deg)`;
                
                setTimeout(() => {
                    wave.style.opacity = '0';
                    setTimeout(() => {
                        wave.remove();
                    }, 3000);
                }, 15000);
            }, 100);
        }
        
        function triggerRandomEffects() {
            if (Math.random() < 0.2) {
                createRandomFlash();
            }
            
            if (Math.random() < 0.3) {
                createRandomWave();
            }
            
            const nextTime = 5000 + Math.random() * 10000;
            setTimeout(triggerRandomEffects, nextTime);
        }
        
        setTimeout(triggerRandomEffects, 3000);
    });
    </script>
</body>
</html>