<?php
session_start();

// Vérifier si l'utilisateur est déjà connecté
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Inclure les fichiers nécessaires
include_once "config/database.php";
include_once "models/User.php";

// Initialiser les variables
$email = $password = "";
$email_err = $password_err = $login_err = "";

// Traitement du formulaire lors de la soumission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Valider l'email
    if (empty(trim($_POST["email"]))) {
        $email_err = "Veuillez entrer votre email.";
    } else {
        $email = trim($_POST["email"]);
    }
    
    // Valider le mot de passe
    if (empty(trim($_POST["password"]))) {
        $password_err = "Veuillez entrer votre mot de passe.";
    } else {
        $password = trim($_POST["password"]);
    }
    
    // Vérifier les erreurs avant de se connecter à la base de données
    if (empty($email_err) && empty($password_err)) {
        // Instancier la base de données
        $database = new Database();
        $db = $database->getConnection();
        
        // Instancier l'objet User
        $user = new User($db);
        
        // Vérifier les identifiants
        if ($user->login($email, $password)) {
            // Démarrer une nouvelle session
            session_start();
            
            // Stocker les données dans les variables de session
            $_SESSION["user_id"] = $user->id;
            $_SESSION["email"] = $email;
            
            // Mettre à jour le statut en ligne
            $user->updateOnlineStatus(1);
            
            // Rediriger vers la page d'accueil
            header("location: index.php");
        } else {
            $login_err = "Email ou mot de passe incorrect.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion - Aurore</title>
    <link rel="stylesheet" href="assets/css/login.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="aurora-container">
        <div class="aurora-light"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
        <div class="aurora-wave"></div>
    </div>
    
    <div class="auth-container">
        <div class="auth-form-container">
            <div class="auth-logo">
                <div class="logo-icon">
                    <i class="fab fa-facebook-messenger"></i>
                </div>
                <h1 data-text="Aurore">Aurore</h1>
            </div>
            
            <?php if (!empty($login_err)): ?>
                <div class="alert alert-danger"><?php echo $login_err; ?></div>
            <?php endif; ?>
            
            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" class="auth-form">
                <div class="form-group <?php echo (!empty($email_err)) ? 'has-error' : ''; ?>">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo $email; ?>">
                    <span class="error-message"><?php echo $email_err; ?></span>
                </div>
                
                <div class="form-group <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
                    <label>Mot de passe</label>
                    <input type="password" name="password" class="form-control">
                    <span class="error-message"><?php echo $password_err; ?></span>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-block">Se connecter</button>
                </div>
                
                <div class="auth-links">
                    <a href="forgot_password.php">Mot de passe oublié ?</a>
                </div>
            </form>
            
            <div class="auth-divider">
                <span>ou</span>
            </div>
            
            <div class="auth-footer">
                <a href="register.php" class="btn btn-block">Créer un nouveau compte</a>
            </div>
        </div>
    </div>

    <script>
    // Script pour ajouter des effets aléatoires à l'aurore
    document.addEventListener('DOMContentLoaded', function() {
        const auroraContainer = document.querySelector('.aurora-container');
        
        // Fonction pour créer un flash aléatoire
        function createRandomFlash() {
            const flash = document.createElement('div');
            flash.className = 'aurora-flash';
            flash.style.position = 'absolute';
            flash.style.width = '100%';
            flash.style.height = '100%';
            flash.style.top = '0';
            flash.style.left = '0';
            flash.style.background = 'radial-gradient(ellipse at center, rgba(255,255,255,0) 0%, rgba(255,255,255,0) 70%, rgba(180,140,255,0.2) 100%)';
            flash.style.opacity = '0';
            flash.style.transition = 'opacity 0.5s ease-in-out';
            flash.style.pointerEvents = 'none';
            
            auroraContainer.appendChild(flash);
            
            // Animation du flash
            setTimeout(() => {
                flash.style.opacity = '0.3';
                setTimeout(() => {
                    flash.style.opacity = '0';
                    setTimeout(() => {
                        flash.remove();
                    }, 500);
                }, 200);
            }, 100);
        }
        
        // Fonction pour créer une vague aléatoire
        function createRandomWave() {
            const wave = document.createElement('div');
            wave.className = 'aurora-wave';
            
            // Position aléatoire
            const positions = [
                { top: '-100%', left: '-50%' },
                { top: '-80%', left: '-10%' },
                { top: '-60%', right: '-30%' },
                { bottom: '-80%', left: '10%' },
                { bottom: '-70%', right: '-20%' }
            ];
            
            const randomPosition = positions[Math.floor(Math.random() * positions.length)];
            
            // Appliquer la position
            Object.keys(randomPosition).forEach(key => {
                wave.style[key] = randomPosition[key];
            });
            
            // Couleur aléatoire
            const colors = [
                'var(--aurora1)',
                'var(--aurora2)',
                'var(--aurora3)',
                'var(--aurora4)',
                'var(--aurora5)',
                'var(--aurora6)',
                'var(--aurora7)',
                'var(--aurora8)'
            ];
            
            wave.style.background = colors[Math.floor(Math.random() * colors.length)];
            wave.style.opacity = '0';
            wave.style.filter = 'blur(60px)';
            wave.style.borderRadius = '40%';
            wave.style.width = '200%';
            wave.style.height = '200%';
            wave.style.transition = 'opacity 3s ease-in-out, transform 30s ease-in-out';
            wave.style.transform = 'translate(0%, 0%) rotate(0deg)';
            
            auroraContainer.appendChild(wave);
            
            // Animation de la vague
            setTimeout(() => {
                wave.style.opacity = '0.3';
                wave.style.transform = `translate(${Math.random() * 20 - 10}%, ${Math.random() * 20 - 10}%) rotate(${Math.random() * 20 - 10}deg)`;
                
                setTimeout(() => {
                    wave.style.opacity = '0';
                    setTimeout(() => {
                        wave.remove();
                    }, 3000);
                }, 15000);
            }, 100);
        }
        
        // Déclencher des effets aléatoires
        function triggerRandomEffects() {
            // Probabilité de 20% pour un flash
            if (Math.random() < 0.2) {
                createRandomFlash();
            }
            
            // Probabilité de 30% pour une nouvelle vague
            if (Math.random() < 0.3) {
                createRandomWave();
            }
            
            // Planifier le prochain effet
            const nextTime = 5000 + Math.random() * 10000; // Entre 5 et 15 secondes
            setTimeout(triggerRandomEffects, nextTime);
        }
        
        // Démarrer les effets aléatoires après un délai initial
        setTimeout(triggerRandomEffects, 3000);
    });
    </script>
</body>
</html>