<?php
// Ce fichier contient les styles CSS pour les paramètres
?>
<style>
    .settings-tab-content {
        padding: 20px;
    }
    
    .settings-form {
        max-width: 600px;
        background-color: #f9f9f9;
        padding: 25px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
    }
    
    .form-group {
        margin-bottom: 20px;
    }
    
    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 500;
    }
    
    .form-control {
        width: 100%;
        padding: 12px;
        border: 1px solid #ddd;
        border-radius: 6px;
        font-size: 15px;
        transition: border-color 0.3s, box-shadow 0.3s;
    }
    
    .form-control:focus {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(126, 63, 242, 0.1);
        outline: none;
    }
    
    .checkbox-label {
        display: flex;
        align-items: center;
        cursor: pointer;
        padding: 8px 0;
    }
    
    .checkbox-label input[type="checkbox"] {
        margin-right: 10px;
        width: 18px;
        height: 18px;
        accent-color: var(--primary-color);
    }
    
    .btn-primary {
        background: linear-gradient(135deg, var(--gradient-start), var(--gradient-middle));
        color: white;
        border: none;
        padding: 12px 20px;
        border-radius: 6px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 5px rgba(126, 63, 242, 0.3);
    }
    
    .btn-primary:hover {
        background: linear-gradient(135deg, var(--gradient-start), var(--gradient-start));
        box-shadow: 0 4px 8px rgba(126, 63, 242, 0.4);
        transform: translateY(-2px);
    }
    
    .alert {
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 20px;
        animation: fadeIn 0.3s ease;
    }
    
    .alert-success {
        background-color: rgba(49, 162, 76, 0.1);
        color: var(--success-color);
        border: 1px solid rgba(49, 162, 76, 0.2);
    }
    
    .alert-danger {
        background-color: rgba(228, 30, 63, 0.1);
        color: var(--error-color);
        border: 1px solid rgba(228, 30, 63, 0.2);
    }
    
    .tab-button {
        padding: 15px 25px;
        background: none;
        border: none;
        font-size: 16px;
        font-weight: 500;
        color: var(--text-secondary);
        cursor: pointer;
        position: relative;
        transition: all 0.3s ease;
    }
    
    .tab-button.active {
        color: var(--primary-color);
        background-color: white;
    }
    
    .tab-button.active::after {
        content: "";
        position: absolute;
        bottom: -1px;
        left: 0;
        right: 0;
        height: 3px;
        background-color: var(--primary-color);
    }
    
    .tab-button:hover:not(.active) {
        background-color: rgba(0, 0, 0, 0.03);
    }
    
    .security-info {
        margin-top: 30px;
        padding: 20px;
        background-color: #f5f7fa;
        border-radius: 8px;
        border-left: 4px solid var(--primary-color);
    }
    
    .security-info h3 {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 15px;
        color: var(--primary-color);
    }
    
    .security-info p {
        margin-bottom: 15px;
        color: var(--text-secondary);
        line-height: 1.6;
    }
    
    .security-tips {
        background-color: white;
        padding: 15px;
        border-radius: 8px;
        margin-top: 15px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .security-tips h4 {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 10px;
        color: var(--text-color);
    }
    
    .security-tips ul {
        list-style-type: disc;
        padding-left: 20px;
    }
    
    .security-tips li {
        margin-bottom: 8px;
        color: var(--text-secondary);
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(-10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .password-strength {
        margin-top: 10px;
    }
    
    .password-strength-bar {
        height: 5px;
        background-color: #eee;
        border-radius: 3px;
        margin-top: 5px;
        overflow: hidden;
    }
    
    .password-strength-indicator {
        height: 100%;
        width: 0;
        background-color: #e74c3c;
        transition: width 0.3s ease, background-color 0.3s ease;
    }
    
    .password-strength-text {
        font-size: 13px;
        margin-top: 5px;
        color: var(--text-secondary);
    }
    
    /* Styles pour les prévisualisations de l'onglet Voir */
    .preview-container {
        margin-top: 20px;
        padding: 15px;
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .preview-title {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 10px;
        color: var(--primary-color);
    }
    
    .message-preview {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }
    
    .preview-message {
        max-width: 70%;
        padding: 10px 15px;
        border-radius: 18px;
        position: relative;
    }
    
    .preview-message.sent {
        align-self: flex-end;
        background: linear-gradient(135deg, var(--gradient-start), var(--gradient-middle));
        color: white;
        border-top-right-radius: 4px;
    }
    
    .preview-message.received {
        align-self: flex-start;
        background-color: #f0f2f5;
        color: var(--text-color);
        border-top-left-radius: 4px;
    }
    
    .preview-message.bubble-square {
        border-radius: 8px;
    }
    
    .preview-message.bubble-rounded {
        border-radius: 18px;
    }
    
    .preview-message.bubble-modern {
        border-radius: 18px 18px 4px 18px;
    }
    
    .preview-message.sent.bubble-modern {
        border-radius: 18px 4px 18px 18px;
    }
    
    .font-small {
        font-size: 13px;
    }
    
    .font-medium {
        font-size: 15px;
    }
    
    .font-large {
        font-size: 17px;
    }
    
    .alignment-standard .preview-message.sent {
        align-self: flex-end;
    }
    
    .alignment-standard .preview-message.received {
        align-self: flex-start;
    }
    
    .alignment-centered .preview-message {
        align-self: center;
        max-width: 80%;
    }
    
    .alignment-right .preview-message {
        align- self: flex-end;
    }
    
    .compact-mode .preview-message {
        padding: 8px 12px;
        margin-bottom: 4px;
    }
    
    .compact-mode .preview-message-time {
        font-size: 10px;
    }
    
    .preview-message-time {
        font-size: 11px;
        margin-top: 2px;
        opacity: 0.8;
    }
    
    .preview-avatar {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: #ddd;
        margin-right: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        color: #666;
    }
    
    .message-with-avatar {
        display: flex;
        align-items: flex-end;
    }
    
    .radio-group {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
    }
    
    .radio-option {
        display: flex;
        align-items: center;
        cursor: pointer;
    }
    
    .radio-option input[type="radio"] {
        margin-right: 5px;
        accent-color: var(--primary-color);
    }
    
    /* Styles pour l'onglet Personnalisation */
    .color-picker-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .color-picker {
        width: 50px;
        height: 40px;
        padding: 0;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }
    
    .color-preview {
        width: 40px;
        height: 40px;
        border-radius: 4px;
        border: 1px solid #ddd;
    }
    
    .color-value {
        font-family: monospace;
        font-size: 14px;
        color: var(--text-secondary);
    }
    
    .background-options {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
        margin-top: 10px;
    }
    
    .background-option {
        cursor: pointer;
        position: relative;
    }
    
    .background-option input[type="radio"] {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }
    
    .background-preview {
        width: 120px;
        height: 80px;
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 500;
        border: 2px solid transparent;
        transition: all 0.3s ease;
    }
    
    .background-option.selected .background-preview {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 2px rgba(126, 63, 242, 0.3);
    }
    
    .default-bg {
        background-color: #f0f2f5;
        color: #333;
    }
    
    .gradient-bg {
        background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
    }
    
    .aurora-bg {
        background: linear-gradient(135deg, #3b1d60 0%, #1c0742 100%);
        position: relative;
        overflow: hidden;
    }
    
    .aurora-bg::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(ellipse at center, rgba(120, 50, 255, 0.3) 0%, rgba(0, 0, 0, 0) 70%);
        animation: rotate 10s linear infinite;
    }
    
    @keyframes rotate {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }
    
    .custom-bg {
        background-color: #333;
        background-image: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%23ffffff' fill-opacity='0.1' fill-rule='evenodd'/%3E%3C/svg%3E");
    }
    
    .emoji-options {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
        margin-top: 10px;
    }
    
    .emoji-option {
        cursor: pointer;
        position: relative;
    }
    
    .emoji-option input[type="radio"] {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }
    
    .emoji-preview {
        width: 120px;
        padding: 10px;
        border-radius: 6px;
        background-color: white;
        border: 2px solid #eee;
        text-align: center;
        transition: all 0.3s ease;
    }
    
    .emoji-option.selected .emoji-preview {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 2px rgba(126, 63, 242, 0.3);
    }
    
    .emoji-sample {
        font-size: 20px;
        margin-bottom: 5px;
        display: block;
    }
    
    .emoji-name {
        font-size: 14px;
        color: var(--text-secondary);
    }
    
    .personalization-preview {
        background-color: #f5f7fa;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .preview-header {
        background: linear-gradient(135deg, var(--accent-color), #5b6af2);
        padding: 15px;
        display: flex;
        align-items: center;
        color: white;
    }
    
    .preview-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background-color: rgba(255, 255, 255, 0.3);
        margin-right: 10px;
    }
    
    .preview-name {
        font-weight: 600;
        margin-bottom: 2px;
    }
    
    .preview-status {
        font-size: 12px;
        opacity: 0.9;
    }
    
    .preview-messages {
        padding: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;
        background-color: white;
        min-height: 150px;
    }
    
    .preview-input {
        display: flex;
        padding: 10px;
        border-top: 1px solid #eee;
        background-color: white;
    }
    
    .preview-input input {
        flex: 1;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 20px;
        margin-right: 10px;
    }
    
    .preview-input button {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        border: none;
        background-color: var(--accent-color);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Styles pour l'onglet Automatisation */
    .auto-reply-message {
        transition: all 0.3s ease;
    }
    
    .templates-container {
        margin-top: 20px;
        transition: all 0.3s ease;
    }
    
    .template-list {
        margin: 15px 0;
        border: 1px solid #eee;
        border-radius: 6px;
        overflow: hidden;
    }
    
    .template-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 15px;
        border-bottom: 1px solid #eee;
        background-color: white;
    }
    
    .template-item:last-child {
        border-bottom: none;
    }
    
    .template-name {
        font-weight: 600;
        margin-bottom: 3px;
    }
    
    .template-text {
        font-size: 13px;
        color: var(--text-secondary);
    }
    
    .template-actions {
        display: flex;
        gap: 5px;
    }
    
    .btn-icon {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: none;
        background-color: #f0f2f5;
        color: var(--text-secondary);
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.2s ease;
    }
    
    .btn-icon:hover {
        background-color: #e4e6e9;
        color: var(--text-color);
    }
    
    .edit-template:hover {
        color: var(--primary-color);
    }
    
    .delete-template:hover {
        color: var(--error-color);
    }
    
    .btn-secondary {
        background-color: #f0f2f5;
        color: var(--text-color);
        border: none;
        padding: 10px 15px;
        border-radius: 6px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s ease;
        display: inline-flex;
        align-items: center;
    }
    
    .btn-secondary i {
        margin-right: 5px;
    }
    
    .btn-secondary:hover {
        background-color: #e4e6e9;
    }
    
    .automation-info {
        margin-top: 30px;
        padding: 20px;
        background-color: #f5f7fa;
        border-radius: 8px;
    }
    
    .automation-info h4 {
        font-size: 18px;
        font-weight: 600;
        margin-bottom: 10px;
        color: var(--primary-color);
    }
    
    .automation-features {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-top: 15px;
    }
    
    .automation-feature {
        flex: 1;
        min-width: 150px;
        background-color: white;
        padding: 15px;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        text-align: center;
    }
    
    .automation-feature i {
        font-size: 24px;
        color: var(--primary-color);
        margin-bottom: 10px;
    }
    
    .automation-feature h5 {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 5px;
    }
    
    .automation-feature p {
        font-size: 13px;
        color: var(--text-secondary);
    }
    
    /* Styles pour l'onglet Admin */
    .admin-dashboard {
        margin-top: 20px;
    }
    
    .admin-stats {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        margin-bottom: 20px;
    }
    
    .admin-stat-card {
        flex: 1;
        min-width: 120px;
        background-color: white;
        padding: 15px;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        display: flex;
        align-items: center;
    }
    
    .stat-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background-color: rgba(126, 63, 242, 0.1);
        color: var(--primary-color);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        margin-right: 15px;
    }
    
    .stat-value {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 2px;
    }
    
    .stat-label {
        font-size: 13px;
        color: var(--text-secondary);
    }
    
    .admin-actions {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        margin-bottom: 20px;
    }
    
    .admin-action-btn {
        flex: 1;
        min-width: 120px;
        background-color: white;
        padding: 15px;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        display: flex;
        flex-direction: column;
        align-items: center;
        text-decoration: none;
        color: var(--text-color);
        transition: all 0.2s ease;
    }
    
    .admin-action-btn i {
        font-size: 24px;
        color: var(--primary-color);
        margin-bottom: 10px;
    }
    
    .admin-action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.15);
    }
    
    .admin-recent-activity {
        margin-top: 20px;
    }
    
    .admin-recent-activity h4 {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 15px;
    }
    
    .activity-list {
        border: 1px solid #eee;
        border-radius: 6px;
        overflow: hidden;
    }
    
    .activity-item {
        display: flex;
        align-items: center;
        padding: 12px 15px;
        border-bottom: 1px solid #eee;
        background-color: white;
    }
    
    .activity-item:last-child {
        border-bottom: none;
    }
    
    .activity-icon {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: rgba(126, 63, 242, 0.1);
        color: var(--primary-color);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
    }
    
    .activity-text {
        font-size: 14px;
    }
    
    .activity-time {
        font-size: 12px;
        color: var(--text-secondary);
        margin-top: 2px;
    }
    
    .access-denied {
        text-align: center;
        padding: 40px 20px;
        background-color: #f9f9f9;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .access-denied-icon {
        font-size: 48px;
        color: var(--text-secondary);
        margin-bottom: 20px;
    }
    
    .access-denied h3 {
        font-size: 20px;
        font-weight: 600;
        margin-bottom: 10px;
    }
    
    .access-denied p {
        color: var(--text-secondary);
        margin-bottom: 10px;
    }
    
    /* Responsive styles for settings tabs */
    @media (max-width: 768px) {
        .settings-tabs {
            flex-wrap: wrap;
            justify-content: flex-start;
        }
        
        .tab-button {
            padding: 10px 15px;
            font-size: 14px;
        }
        
        .admin-stats, .admin-actions {
            flex-direction: column;
        }
        
        .admin-stat-card, .admin-action-btn {
            min-width: 100%;
        }
        
        .background-options, .emoji-options {
            justify-content: center;
        }
    }
</style>